<?php 
   /**
    *
    * copyright (c) 2013-2023 Heliac Technologies
    * license http://opensource.org/licenses/gpl-license.php GNU GPL v3 
    *
    * linee guida per l'utilizzo del logo http://www.geecom.org/index.php?alias=linee-guida-per-luso-del-logo-geecom
    */

    include "../include/includeBaseComponenti.php";
    include "../../../template/stile.php";
    include "classi/Form.php";
    
    if(isset($_GET["id"])) {
        $form = new Form($geecomDb, filter_input(INPUT_GET, "id",FILTER_SANITIZE_NUMBER_INT));
        $form->caricaDatiDalDatabase();
    }
    else {
        $form = new Form($geecomDb, 0);
    }
    
    if(isset($_GET["status"])) {
        $status = filter_input(INPUT_GET,"status",FILTER_SANITIZE_NUMBER_INT);
    }
    else {
        $status = 0;
    }
?>
<!doctype html>
<html lang="en">
    <head>
        <!-- Required meta tags -->
        <meta charset="utf-8">
        <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">

        <?php
            include "../include/cssBaseComponenti.php";
        ?>
        <title>Geecom Admin - Creazione form</title>
    </head>
    <body>
    
        <header>
            <?php 
                include "../../include/barraSuperiore.php";

                include "../../include/header.php";

                include "../../include/barraMenu.php";
            ?>
        </header>

        <main role="main" class="bg-light" id="main">
            <div class="container-fluid">
                <div class="row py-4">
                    <?php 
                        if($status==200) {
                            echo"<div class=\"col-12\">
                                    <div class=\"alert alert-success alert-dismissible fade show\" role=\"alert\">
                                        Form creato
                                        <button type=\"button\" class=\"close\" data-dismiss=\"alert\" aria-label=\"Close\">
                                              <span aria-hidden=\"true\">&times;</span>
                                        </button>
                                    </div>
                                </div>";
                        }
                        
                        if($status==250) {
                            echo"<div class=\"col-12\">
                                    <div class=\"alert alert-success alert-dismissible fade show\" role=\"alert\">
                                        Informazioni di base aggiornate
                                        <button type=\"button\" class=\"close\" data-dismiss=\"alert\" aria-label=\"Close\">
                                              <span aria-hidden=\"true\">&times;</span>
                                        </button>
                                    </div>
                                </div>";
                        }
                        else if($status==250) {
                            echo"<div class=\"col-12\">
                                    <div class=\"alert alert-success alert-dismissible fade show\" role=\"alert\">
                                        Informazioni sulle conferme aggiornate
                                        <button type=\"button\" class=\"close\" data-dismiss=\"alert\" aria-label=\"Close\">
                                              <span aria-hidden=\"true\">&times;</span>
                                        </button>
                                    </div>
                                </div>";
                        }
                        else if($status==252) {
                            echo"<div class=\"col-12\">
                                    <div class=\"alert alert-success alert-dismissible fade show\" role=\"alert\">
                                        Informazioni sulle notifiche aggiornate
                                        <button type=\"button\" class=\"close\" data-dismiss=\"alert\" aria-label=\"Close\">
                                              <span aria-hidden=\"true\">&times;</span>
                                        </button>
                                    </div>
                                </div>";
                        }
                    ?>
                    <div class="col-12">
                        <div class="form-row justify-content-between mb-3">
                            <div class="col-auto d-flex">
                                <nav aria-label="breadcrumb" class="align-self-center">
                                    <ol class="breadcrumb p-0 mb-1 mb-md-0 bg-transparent">
                                        <li class="breadcrumb-item"><a href="../../home.php">Home</a></li>
                                        <li class="breadcrumb-item"><a href="#" data-toggle="modal" data-target="#menu-componenti">Componenti</a></li>
                                        <li class="breadcrumb-item"><a href="index.php">Form</a></li>
                                        <li class="breadcrumb-item active" aria-current="page">
                                        <?php 
                                            echo((isset($form)? $form->getNome() : "Nuovo form"));
                                            
                                            $numeroMessaggi = $geecomDb->contaRigheTabella("geec_messaggiForm",array("idForm"=>$form->getId()));

                                            if($numeroMessaggi>0) {
                                        ?>
                                            <a href="elencoMessaggi.php?id=<?= ((isset($form) ? $form->getId() : "0")); ?>"><span class="badge badge-primary ml-2"><?=  $numeroMessaggi ?></span></a>
                                        <?php 
                                            }
                                        ?>
                                        </li>
                                    </ol>
                                </nav>
                            </div>
                            <div class="col-auto text-right">
                                <a class="btn btn-outline-primary" href="index.php"><i class="fas fa-arrow-left mr-2"></i>Torna all'elenco</a>
                                <button type="button" class="btn btn-warning" onclick="location.href='controller/controllerComponente.php?id=1&amp;operazione=duplica';"><i class="far fa-clone mr-2"></i>Duplica</button>
                            </div>
                        </div>
                        <ul class="nav nav-tabs" id="myTab" role="tablist">
                            <li class="nav-item" role="presentation">
                                <a class="nav-link <?= ($status==0 || $status==200 || $status==250) ? "active" : "" ?>" data-toggle="tab" href="#impostazioniGenerali" role="tab" aria-controls="home" aria-selected="true">Impostazioni generali</a>
                            </li>
                            <?php 
                                if(isset($form) && $form->getId()>0) {
                            ?>
                                <li class="nav-item" role="presentation">
                                    <a class="nav-link <?= ($status==251) ? "active" : "" ?>" data-toggle="tab" href="#conferme" role="tab" aria-controls="profile" aria-selected="false">Conferme</a>
                                </li>
                                <li class="nav-item" role="presentation">
                                    <a class="nav-link <?= ($status==252) ? "active" : "" ?>" data-toggle="tab" href="#notifiche" role="tab" aria-controls="contact" aria-selected="false">Notifiche</a>
                                </li>
                                <li class="nav-item" role="presentation">
                                    <a class="nav-link <?= ($status==100) ? "active" : "" ?>" data-toggle="tab" href="#campi" role="tab" aria-controls="contact" aria-selected="false">Campi</a>
                                </li>
                            <?php
                                }
                            ?>
                        </ul>
                        <div class="tab-content" id="myTabContent">                                
                            <div class="tab-pane fade <?= ($status==0 || $status==200 || $status==250) ? "show active" : "" ?>" id="impostazioniGenerali" role="tabpanel" aria-labelledby="home-tab">
                                <form name="formImpostazioniGenerali" action="controller/controllerComponente.php" method="post">
                                    <input type="text" class="d-none" name="operazione" value="<?= ((isset($form) && $form->getId()!=0) ? "aggiornaDatiPrincipali" : "crea"); ?>">
                                    <input type="text" class="d-none" name="id" value="<?= ((isset($form) ? $form->getId() : "0")); ?>">
                                    
                                    <div class="row">
                                        <div class="col-md-3 form-group">
                                            <label>Nome</label>
                                            <input type="text" class="form-control" id="nomeSlider" name="nome" aria-describedby="nome griglia" value="<?= ((isset($form) ? $form->getNome() : "")) ?>" placeholder="Nome occorrenza">
                                        </div>

                                        <div class="col-md-3 form-group">
                                            <label>Spazio occupato</label>
                                            <select class="form-control" name="spazioOccupato">
                                            <?php 
                                                foreach($arrayDimensioniColonna as $classe=>$descrizione) {
                                                    if(isset($form) && $form->getSpazioOccupato()==$classe) {
                                                        echo"<option value=\"$classe\" selected>$descrizione</option>";
                                                    }
                                                    else {
                                                        echo"<option value=\"$classe\">$descrizione</option>";
                                                    }
                                                }
                                            ?>
                                            </select>
                                            <small class="text-muted">Lo spazio orizzontale occupato dal componente</small>
                                        </div>

                                        <div class="col-md-3 form-group">
                                            <label for="select1" class="d-block mr-3">Mostra nome </label>
                                            <input type="checkbox" name="mostraTitoloComponente" class="js-switch" value="si" <?php
                                                  if(isset($form) && $form->getMostraTitoloComponente()=="si") { // se il valore = si aggiunge la parola checked
                                                    echo"CHECKED";
                                                 }
                                              ?> />
                                            <small class="text-muted d-block">Il nome della form verrà visualizzato dagli utenti</small>
                                        </div>

                                        <div class="w-100"></div>

                                        <div class="col-md-3 form-group">
                                            <label class="d-block">Etichetta pulsante invia</label>
                                            <input type="text" class="form-control" id="url-seo" name="etichettaPulsante" value="<?= ((isset($form)? $form->getEtichettaPulsante() : ""))?>" placeholder="Etichetta pulsante">
                                            <small class="text-muted">Etichetta del pulsante di invio del form</small>
                                        </div>               
                                        
                                        <div class="col-md-3 form-group">
                                            <label class="d-block">Icona pulsante invia</label>
                                            <input type="text" class="form-control" id="url-seo" name="iconaPulsante" value="<?= ((isset($form)? $form->getIconaPulsante() : ""))?>" placeholder="Icona pulsante">
                                            <small class="text-muted">Comparirà accanto all'etichetta del pulsante di invio del form</small>
                                        </div>

                                        <div class="col-md-3 form-group">
                                            <label>Spazio occupato dal pulsante</label>
                                            <select class="form-control" name="spazioOccupatoPulsante">
                                            <?php 
                                                $arrayDimensioniColonna = ["col-12"=>"intera riga","col-lg-10"=>"5/6 della riga","col-lg-8"=>"2/3 della riga", "col-lg-6"=>"1/2 della riga","col-lg-4"=>"1/3 della riga","col-lg-3"=>"1/4 della riga"];
                                                foreach($arrayDimensioniColonna as $classe=>$descrizione) {
                                                    if(isset($form) && $form->getSpazioOccupatoPulsante()==$classe) {
                                                        echo"<option value=\"$classe\" selected>$descrizione</option>";
                                                    }
                                                    else {
                                                        echo"<option value=\"$classe\">$descrizione</option>";
                                                    }
                                                }
                                            ?>
                                            </select>
                                            <small class="text-muted">Lo spazio orizzontale occupato dal pulsante</small>
                                        </div>

                                        <div class="col-md-3 form-group">
                                            <label for="select1" class="d-block mr-3">Pulsante in linea</label>
                                            <input type="checkbox" name=formInLinea class="js-switch" value="si" <?php
                                                  if(isset($form) && $form->getFormInLinea()=="si") { // se il valore = si aggiunge la parola checked
                                                    echo"CHECKED";
                                                 }
                                              ?> />
                                            <small class="text-muted d-block">Se selezionato il pulsante verrà visualizzato accanto agli altri campi</small>
                                        </div>  

                                        <div class="w-100"></div>

                                        <div class="col-md-3 form-group">
                                            <label class="d-block">Azione</label>
                                            <select class="form-control" id="azione" name="azione" onchange="mostraInputRichiesti(this.value)">
                                                    <?php 
                                                        $arrayAzioni = ["Invia email","Invio a script personalizzato","Usa come form ricerca"];
                                                        foreach($arrayAzioni as $azione) {
                                                            if(isset($form) && $form->getAzione()==$azione) {
                                                                echo"<option value=\"$azione\" selected>$azione</option>";
                                                            }
                                                            else {
                                                                echo"<option value=\"$azione\">$azione</option>";
                                                            }
                                                        }
                                                    ?>
                                            </select>
                                            <small class="text-muted">Seleziona l'azione da svolgere</small>
                                        </div>
                                        
                                        <div id="divLinkScriptEsterno" class="<?= ($form->getAzione()=="Invio a script personalizzato") ? "col-md-3 form-group" : "d-none" ?>">
                                            <label class="d-block">Link script esterno</label>
                                            <input type="text" class="form-control" id="url-seo" name="linkScriptEsterno" value="<?= ((isset($form)? $form->getLinkScriptEsterno() : ""))?>" placeholder="Link script ricerca">
                                            <small class="text-muted">Il link dove verrà reindirizzato l'utente quando cliccherà sul pulsante cerca</small>
                                        </div>
                                    </div>

                                    <div id="divDatiTradizionali" class="<?= ($form->getAzione()!="Usa come form ricerca") ? "row" : "d-none" ?>">

                                        <div class="col-md-3 form-group">
                                            <label class="d-block">Link privacy</label>
                                            <input type="text" class="form-control" id="url-seo" name="linkPrivacy" value="<?= ((isset($form)? $form->getLinkPrivacy() : ""))?>" placeholder="Link privacy">
                                            <small class="text-muted"> L'indirizzo della pagina dove sono elencate le condizioni della privacy </small>
                                        </div>

                                        <div class="col-md-3 form-group">
                                            <label for="select1" class="d-block mr-3">Spunta privacy </label>
                                            <input type="checkbox" name=spuntaPrivacy class="js-switch" value="si" <?php
                                                  if(isset($form) && $form->getSpuntaPrivacy()=="si") { // se il valore = si aggiunge la parola checked
                                                    echo"CHECKED";
                                                 }
                                              ?> />
                                            <small class="text-muted d-block">Attiva questo campo se vuoi obbligare l'utente ad accettare le condizioni sulla privacy</small>
                                        </div>
                                    </div>

                                    <div id="divDatiRicerca" class="<?= ($form->getAzione()=="Usa come form ricerca") ? "row" : "d-none" ?>">
                                        <div class="col-md-3 form-group">
                                            <label class="d-block">Link script ricerca</label>
                                            <input type="text" class="form-control" id="url-seo" name="linkScriptRicerca" value="<?= ((isset($form)? $form->getLinkScriptRicerca() : ""))?>" placeholder="Link script ricerca">
                                            <small class="text-muted">Il link dove verrà reindirizzato l'utente quando cliccherà sul pulsante cerca</small>
                                        </div>

                                        <div class="col-md-3 form-group">
                                            <label for="select1" class="d-block mr-3">Usa ajax</label>
                                            <input type="checkbox" name=usaAjax class="js-switch" value="si" <?php
                                                  if(isset($form) && $form->getUsaAjax()=="si") { // se il valore = si aggiunge la parola checked
                                                    echo"CHECKED";
                                                 }
                                              ?> />
                                            <small class="text-muted d-block">Invia via email l'URL della pagina in cui l'utente ha compilato il form</small>
                                        </div>
                                    </div>

                                    <div class="row">
                                        <div class="col-md-3 form-group">
                                            <label class="d-block">Note aggiuntive</label>
                                            <textarea class="form-control" name="noteAggiuntive" row="2"><?= ((isset($form)? $form->getNoteAggiuntive() : ""))?></textarea>
                                            <small class="text-muted">Se presenti verranno visualizzate alla fine del form</small>
                                        </div>
                                    </div>
                                </form>
                                <button type="button" class="btn btn-primary float-right" onclick="document.formImpostazioniGenerali.submit()"><i class="fas fa-check"></i> Salva</button>
                            </div>

                            <div class="tab-pane fade <?= ($status==251) ? "show active" : "" ?>" id="conferme" role="tabpanel" aria-labelledby="profile-tab">
                                <form name="formDatiConferma" action="controller/controllerComponente.php" method="post">
                                    <input type="text" class="d-none" name="operazione" value="aggiornaDatiConferme">
                                    <input type="text" class="d-none" name="id" value="<?= ((isset($form) ? $form->getId() : "0")); ?>">
                                    
                                    <div class="row">
                                        <div class="<?= ($form->getAzione()!="Invio a script personalizzato") ? "col-md-3 form-group" : "d-none" ?>">
                                            <label class="d-block">Tipo di conferma</label>
                                            <select class="form-control" id="tipoDiConferma" name="tipoConfermaMessaggioInviato" onchange="mostraTestoMessaggioInviato(this.value)">
                                                <?php
                                                    $tipiConferme = array("Reindirizzamento ad altra pagina","Messaggio a video");

                                                    foreach($tipiConferme as $tipo) {
                                                        
                                                        $selezionato = ($form->getTipoConfermaMessaggioInviato()==$tipo) ? "selected" : "";
                                                        ?>
                                                        <option value="<?= $tipo ?>" <?= $selezionato ?>><?= $tipo ?></option>
                                                        <?php
                                                    }
                                                ?>
                                            </select>
                                            <small class="text-muted">Il tipo di conferma che riceve l'utente quando ha compilato il form</small>
                                        </div>
                                        
                                        <div id="divPaginaRingraziamento" class="<?= ($form->getAzione()!="Invio a script personalizzato") ? "col-md-3 form-group" : "d-none" ?>">
                                            <label class="d-block">Pagina di ringraziamento</label>
                                            <select class="form-control" id="paginaRingraziamento" name="paginaRingraziamento">
                                                <option value="0" >Seleziona</option>
                                                <?php
                                                    $parametri = array("tabella"=>"geecAd_contenuti", "elementiPerPagina"=>100,"parametriRicerca"=>array("tipo"=>"pagina"),"ajax"=>false);
                                                    $ricercaPagine = new Ricerca($geecomDb, $parametri,$impostazioniRicerca,"creaForm.php");
                                                    $risultatoQueryPagine = $ricercaPagine->eseguiRicerca(1);
                                                    while($pagina = $risultatoQueryPagine->fetch_assoc()) {
                                                        if(isset($form) && $form->getPaginaRingraziamento()==$pagina["id"]) {
                                                            $selezionato  = "selected";
                                                        }
                                                        else {
                                                            $selezionato  = "";
                                                        }
                                                        echo"<option value=\"{$pagina["id"]}\" $selezionato >{$pagina["titolo"]}</option>";
                                                    }
                                                ?>
                                            </select>
                                            <small class="text-muted"> L'URL a cui viene reindirizzato l'utente</small>
                                        </div>
                                        
                                        <div class="w-100"></div>
                                        
                                        <div id="divTestoMessaggioInviato" class="<?= ($form->getAzione()=="Invio a script personalizzato" || $form->getPaginaRingraziamento()==0) ? "d-none" : "col-md-3 form-group" ?>">
                                            <label class="d-block">Testo messaggio inviato</label>
                                            <textarea class="form-control" name="testoMessaggioInviato" row="2"><?= ((isset($form)? $form->getTestoMessaggioInviato() : ""))?></textarea>
                                            <small class="text-muted">Il testo che verrà visualizzato se il form viene inviato correttamente</small>
                                        </div>
                                        
                                        <div class="col-md-3 form-group">
                                            <label class="d-block">Messaggio di errore</label>
                                            <textarea class="form-control" name="testoMessaggioErrore" row="2"><?= ((isset($form)? $form->getTestoMessaggioErrore() : ""))?></textarea>
                                            <small class="text-muted">Personalizza il messaggio che comparirà se il modulo non viene inviato</small>
                                        </div>
                                    </div>
                                </form>
                                <button type="button" class="btn btn-primary float-right" onclick="document.formDatiConferma.submit()"><i class="fas fa-check"></i> Salva</button>
                            </div>

                            <div class="tab-pane fade <?= ($status==252) ? "show active" : "" ?>" id="notifiche" role="tabpanel" aria-labelledby="contact-tab">
                                <form name="formDatiNotifiche" action="controller/controllerComponente.php" method="post">
                                    <input type="text" class="d-none" name="operazione" value="aggiornaDatiNotifiche">
                                    <input type="text" class="d-none" name="id" value="<?= ((isset($form) ? $form->getId() : "0")); ?>">
                                    
                                    <div class="row">
                                        <div class="col-md-3 form-group">
                                            <label class="d-block">Email amministrativa</label>
                                            <input type="text" class="form-control" id="url-seo" name="emailNotificaAmministratore" value="<?= ((isset($form)? $form->getEmailNotificaAmministratore() : ""))?>" placeholder="Email destinatario">
                                            <small class="text-muted"> L'indirizzo email a cui verrà inviato il form, se è vuoto non verranno inviate email </small>
                                        </div>

                                        <div class="col-md-3 form-group">
                                            <label class="d-block">Rispondi a</label>
                                            <select class="form-control" id="rispondiA" name="rispondiA">
                                                <?php
                                                    $parametri     = array("tabella"=>"geec_elementiForm", "elementiPerPagina"=>100,"parametriRicerca"=>array("idForm"=>$form->getId(),"tipo"=>["Testo","Email"]),"ajax"=>false);
                                                    $ricercaPagine = new Ricerca($geecomDb, $parametri,$impostazioniRicerca,"creaForm.php");
                                                    $risultatoQueryElemento = $ricercaPagine->eseguiRicerca(1);
                                                    while($elemento = $risultatoQueryElemento->fetch_assoc()) {
                                                        if(isset($elemento) && $form->getRispondiA()==$elemento["nome"]) {
                                                            $selezionato  = "selected";
                                                        }
                                                        else {
                                                            $selezionato  = "";
                                                        }
                                                        echo"<option value=\"{$elemento["nome"]}\" $selezionato >{$elemento["nome"]}</option>";
                                                    }
                                                ?>
                                            </select>
                                            <small class="text-muted">Seleziona il campo dove l'utente inserirà la sua email</small>
                                        </div>
                                        
                                        <div class="col-md-3 form-group">
                                            <label class="d-block">Oggetto </label>
                                            <input type="text" class="form-control" id="url-seo" name="oggettoNotificaAmministratore" value="<?= ((isset($form)? $form->getOggettoNotificaAmministratore() : ""))?>" placeholder="Oggetto">
                                            <small class="text-muted"> L'oggetto della mail di notifica per l'amministratore </small>
                                        </div>
                                        
                                        <div class="col-md-3 form-group">
                                            <label for="select1" class="d-block mr-3">Invia link pagina form</label>
                                            <input type="checkbox" name=stampaLinkPaginaForm class="js-switch" value="si" <?php
                                                  if(isset($form) && $form->getStampaLinkPaginaForm()=="si") { // se il valore = si aggiunge la parola checked
                                                    echo"CHECKED";
                                                 }
                                              ?> />
                                            <small class="text-muted d-block">Invia via email l'URL della pagina in cui l'utente ha compilato il form</small>
                                        </div>
                                        
                                        <div class="col-12">
                                            <input type="checkbox" id="attivaNotificaUtente" name="attivaNotificaUtente" class="js-switch" value="si" <?php
                                                  if(isset($form) && $form->getAttivaNotificaUtente()=="si") { // se il valore = si aggiunge la parola checked
                                                    echo"CHECKED";
                                                 }
                                              ?>  onchange="mostraDivDatiNotificheUtente(this.value)" />
                                            
                                            <h5 class="d-inline ml-2">Notifica aggiuntiva</h5>
                                            <hr>
                                        </div>
                                        
                                        <div id="divDatiNotificheUtente" class="<?= ($form->getAttivaNotificaUtente()=="si") ? "col-12" : "d-none" ?>">
                                            <div class="row">
                                                <div class="col-md-3 form-group">
                                                    <label class="d-block">Nome mittente</label>
                                                    <input type="text" class="form-control" id="nomeMittenteNotificaUtente" name="nomeMittenteNotificaUtente" value="<?= ((isset($form)? $form->getNomeMittenteNotificaUtente() : ""))?>" placeholder="Nome mittente">
                                                    <small class="text-muted"> Il nome del mittente inserito nell'email che riceverà l'utente </small>
                                                </div>

                                                <div class="col-md-3 form-group">
                                                    <label class="d-block">Email mittente</label>
                                                    <input type="text" class="form-control" id="emailMittenteNotificaUtente" name="emailMittenteNotificaUtente" value="<?= ((isset($form)? $form->getEmailMittenteNotificaUtente() : ""))?>" placeholder="Email mittente">
                                                    <small class="text-muted"> L'indirizzo email a cui verrà inviato il form, se è vuoto non verranno inviate email </small>
                                                </div>

                                                <div class="col-md-3 form-group">
                                                    <label class="d-block">Destinatario</label>
                                                    <select class="form-control" id="campoEmailNotificaUtente" name="campoEmailNotificaUtente">
                                                        <?php
                                                            $parametri     = array("tabella"=>"geec_elementiForm", "elementiPerPagina"=>100,"parametriRicerca"=>array("idForm"=>$form->getId(),"tipo"=>["Testo","Email"]),"ajax"=>false);
                                                            $ricercaPagine = new Ricerca($geecomDb, $parametri,$impostazioniRicerca,"creaForm.php");
                                                            $risultatoQueryElemento = $ricercaPagine->eseguiRicerca(1);
                                                            while($elemento = $risultatoQueryElemento->fetch_assoc()) {
                                                                if(isset($elemento) && $form->getCampoEmailNotificaUtente()==$elemento["nome"]) {
                                                                    $selezionato  = "selected";
                                                                }
                                                                else {
                                                                    $selezionato  = "";
                                                                }
                                                                echo"<option value=\"{$elemento["nome"]}\" $selezionato >{$elemento["nome"]}</option>";
                                                            }
                                                        ?>
                                                    </select>
                                                    <small class="text-muted">Seleziona il campo dove l'utente inserirà la sua email</small>
                                                </div>
                                                
                                                <div class="col-md-3 form-group">
                                                    <label class="d-block">Oggetto </label>
                                                    <input type="text" class="form-control" id="oggettoNotificaUtente" name="oggettoNotificaUtente" value="<?= ((isset($form)? $form->getOggettoNotificaUtente() : ""))?>" placeholder="Oggetto della mail">
                                                    <small class="text-muted"> L'oggetto che verrà inserito nella mail che riceverà l'utente</small>
                                                </div>

                                                <div id="divPaginaRingraziamento" class="<?= ($form->getAzione()!="Invio a script personalizzato") ? "col-md-3 form-group" : "d-none" ?>">
                                                    <label class="d-block">Template email</label>
                                                    <select class="form-control" id="templateEmailNotificaUtente" name="templateEmailNotificaUtente">
                                                        <?php
                                                            $parametri = array("tabella"=>"geec_templateEmail", "elementiPerPagina"=>100,"parametriRicerca"=>array(),"ajax"=>false);
                                                            $ricercaPagine = new Ricerca($geecomDb, $parametri,$impostazioniRicerca,"creaForm.php");
                                                            $risultatoQueryPagine = $ricercaPagine->eseguiRicerca(1);
                                                            while($templateEmail = $risultatoQueryPagine->fetch_assoc()) {
                                                                if(isset($form) && $form->getTemplateEmailNotificaUtente()==$templateEmail["id"]) {
                                                                    $selezionato  = "selected";
                                                                }
                                                                else {
                                                                    $selezionato  = "";
                                                                }
                                                                echo"<option value=\"{$templateEmail["id"]}\" $selezionato >{$templateEmail["nome"]}</option>";
                                                            }
                                                        ?>
                                                    </select>
                                                    <small class="text-muted">Il template che viene utilizzato per la mail di notifica per l'utente</small>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </form>

                                <button type="button" class="btn btn-primary float-right" onclick="document.formDatiNotifiche.submit()"><i class="fas fa-check"></i> Salva</button>
                            </div>
                            
                            <div class="tab-pane fade <?= ($status==100) ? "show active" : "" ?>" id="campi" role="tabpanel" aria-labelledby="contact-tab">
                                <?php 
                                    if(isset($form) && $form->getId()>0) {
                                ?>
                                    <div class="row">
                                        <div class="col-12">
                                            <div class="card mb-3">
                                                <div class="card-header collapsed" data-toggle="collapse" href="#templateForm">
                                                    <a class="card-title">
                                                        Carica da template 
                                                    </a>
                                                </div>

                                                <div id="templateForm" class="collapse">
                                                    <div class="card-body">
                                                        <a href="#" class="btn btn-outline-primary">Contatto semplice</a>
                                                        <a href="#" class="btn btn-outline-primary">Iscrizione newsletter</a>
                                                        <a href="#" class="btn btn-outline-primary">Iscrizione newsletter Geecom Admin</a>
                                                        <a href="#" class="btn btn-outline-primary">Crea nuovo utente Geecom Admin</a>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                        
                                        <div class="col-lg-4 col-xl-3 sticky-top align-self-start">
                                            <form>
                                                <div class="mb-4 add-box">
                                                    <div class="form-row">
                                                        <?php
                                                            $tipiCampo = array(
                                                                    "Testo"    =>"template/img/componenti/inputForm/icon_input_text.svg",
                                                                    "Email"    =>"template/img/componenti/inputForm/icon_input_email.svg",
                                                                    "Tendina"  =>"template/img/componenti/inputForm/icon_input_select.svg",
                                                                    "Area testo" =>"template/img/componenti/inputForm/icon_input_textarea.svg",
                                                                    "Data"       =>"template/img/componenti/inputForm/icon_input_data.svg",
                                                                    "Orario"     =>"template/img/componenti/inputForm/icon_input_ora.svg",
                                                                    "Checkbox"   =>"template/img/componenti/inputForm/icon_input_checkbox.svg",
                                                                    "Codice univoco" =>"template/img/componenti/inputForm/icon_input_codiceUnivoco.svg");

                                                            foreach($tipiCampo as $tipo=>$immagine) {
                                                                ?>
                                                                <div class="col-4 col-sm-3 col-md-2 col-lg-4">
                                                                    <a class="btn btn-light btn-block" href="javascript:void" onclick="aggiungiElementoForm('<?=  $tipo ?>')">
                                                                            <img class="img-fluid" src="../../../<?=  $immagine ?>" alt="<?=  $tipo ?>">
                                                                            <h6><?=  $tipo ?></h6>
                                                                    </a>
                                                                </div>
                                                                <?php
                                                            }
                                                        ?>
                                                    </div>
                                                </div>
                                            </form>
                                        </div>

                                        <div class="col-lg-8 col-xl-9">
                                            <div id="divElencoElementi" class="wrapper-sezioni-pagina">
                                                <?php 
                                                    $form->stampaElementi($tipiCampo);
                                                ?>
                                            </div>
                                        </div>
                                    </div>
                                <?php
                                    }
                                ?>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </main>

        <?php
            include "../../include/footer.php";

            include "../include/modal/cambiaPassword.php";
            
            include "../include/modal/eliminaElemento.php";

            include "../../include/modal/modalMenuComponenti.php";

            include "../../include/modal/operazioneCompletata.php";

            include "../include/jsBaseComponenti.php";
        ?>

        <script>
            function mostraTestoMessaggioInviato(tipoConferma) {
                var azione = document.getElementById("azione").value;
                document.getElementById("divTestoMessaggioInviato").className = "d-none";
                document.getElementById("divPaginaRingraziamento").className  = "d-none";
                
                if(tipoConferma=="Messaggio a video") {
                    document.getElementById("divTestoMessaggioInviato").className = "col-md-3 form-group";
                }
                else {
                    document.getElementById("divPaginaRingraziamento").className  = "col-md-3 form-group";
                }
            }
            
            function mostraDivDatiNotificheUtente() {
                document.getElementById("divDatiNotificheUtente").className  = "d-none";
                
                if(document.getElementById("attivaNotificaUtente").checked) {
                    document.getElementById("divDatiNotificheUtente").className  = "col-12";
                }
            }
            
            function mostraInputRichiesti(azione) {
                var paginaRingraziamento = document.getElementById("paginaRingraziamento").value;
                
                document.getElementById("divDatiTradizionali").className  = "d-none";
                document.getElementById("divLinkScriptEsterno").className = "d-none";
                document.getElementById("divDatiRicerca").className       = "d-none";
                document.getElementById("divTestoMessaggioInviato").className = "d-none";
                document.getElementById("divPaginaRingraziamento").className  = "d-none";
                
                if(azione==="Usa come form ricerca") {
                    document.getElementById("divDatiRicerca").className = "row";
                }
                else if(azione=="Invio a script personalizzato") {
                    document.getElementById("divDatiTradizionali").className = "row";
                    document.getElementById("divLinkScriptEsterno").className = "col-md-3 form-group";
                }
                else {
                    document.getElementById("divDatiTradizionali").className = "row";
                    if(paginaRingraziamento==0) {
                        document.getElementById("divTestoMessaggioInviato").className = "col-md-9 form-group";
                    }
                    document.getElementById("divPaginaRingraziamento").className  = "col-md-3 form-group";
                }
            }
            
            function eliminaElemento(id,nomeElemento,tipoElemento) {
                $('#elementoDaEliminare').val(id);
                $('#nomeElementoDaEliminare').text(nomeElemento);
                $('#modalEliminaElemento').modal('show');
            }
            
            function eseguiEliminazioneElemento() {
                var id = $('#elementoDaEliminare').val();
                $.ajax({
                    type:"POST",
                    url:"controller/controllerComponente.php",
                    data:{
                        operazione:"eliminaElemento",
                        id:<?=  $form->getId() ?>,
                        idElemento:id
                    },
                    success:function(esito) {
                        if(esito=="ok") {
                            document.getElementById("elementoComponente"+id).className = "d-none";
                            $('#modalEliminaElemento').modal('hide');
                        }
                    },
                    error: function() {
                        alert("Si sono verificato problemi durante la richiesta, riprova tra qualche istante");
                    }
                });
            }
            
            function spostaElementoInput(id) {
                var posizione = $('#nuovaPosizioneElemento'+id).val();
                spostaElemento(id,posizione);
            }
            
            function spostaElemento(id,posizione) {
                $.ajax({
                    type:"POST",
                    url:"controller/controllerComponente.php",
                    data:{
                        operazione:"spostaElemento",
                        id:<?=  $form->getId() ?>,
                        idElemento:id,
                        posizione:posizione
                    },
                    success:function(esito) {
                        if(esito=="ok") {
                            aggiornaDivElementi();
                        }
                        else {
                            alert(esito);
                        }
                    },
                    error: function() {
                        alert("Si sono verificato problemi durante la richiesta, riprova tra qualche istante");
                    }
                });
            }
            
            function creaElemento() {
                var nome   = $('#nomeElemento').val();
                var tipo   = $('#tipoElemento').val();
                var valore = $('#valoreElemento').val();
                
                $.ajax({
                    type:"POST",
                    url:"controller/controllerComponente.php",
                    data:{
                        operazione:"creaElemento",
                        id:<?=  $form->getId() ?>,
                        nome:nome,
                        tipo:tipo,
                        valore:valore
                    },
                    success:function(esito) {
                        if(esito=="ok") {
                            aggiornaDivElementi();
                        }
                        else {
                            alert("Si è verificato un errore, contatta l'amministratore del sito")
                        }
                    },
                    error: function() {
                        alert("Si sono verificato problemi durante la richiesta, riprova tra qualche istante");
                    }
                });
            }
            
            function aggiornaDivElementi() {
                $.ajax({
                    type:"POST",
                    url:"controller/controllerComponente.php",
                    data:{
                        operazione:"stampaElementi",
                        id:<?=  $form->getId() ?>
                    },
                    success:function(result) {
                        document.getElementById("divElencoElementi").innerHTML = result;
                        $('#modifica-voce-menu').modal('hide');
                    },
                    error: function() {
                        alert("Si sono verificato problemi durante la richiesta, riprova tra qualche istante");
                    }
                });
            }
            
            function aggiungiElementoForm(tipo) {

                $.ajax({
                    type:"POST",
                    url:"controller/controllerComponente.php",
                    data:{
                        operazione:'creaElemento',
                        id:<?= $form->getId() ?>,
                        tipo:tipo
                    },
                    success:function(esito) {
                        if(esito=="ok") {
                            aggiornaDivElementi();
                        }
                        else {
                            alert(esito);
                        }
                    },
                    error:function(){
                        alert("errore");
                    }
                });
            }
            
            function modificaRapidaElemento(id) {
                var nomeElemento	 = document.getElementById("nomeElemento"+id).value;
                var etichettaElemento	 = document.getElementById("etichettaElemento"+id).value;
                var valoreElemento	 = document.getElementById("valoreElemento"+id).value;
                
                $.ajax({
                    type:"POST",
                    url:"controller/controllerComponente.php",
                    data:{
                        operazione:"modificaRapidaElemento",
                        id:<?= $form->getId() ?>,
                        idElemento:id,
                        nome:nomeElemento,
                        etichetta:etichettaElemento,
                        valore:valoreElemento
                    },
                    success:function(result) {
                        $('#labelOperazioneCompletata').text("Elemento salvato");
                        $('#modalOperazioneCompletata').modal('show');
                    },
                    error: function(xhr, ajaxOptions, thrownError) {
                        alert(xhr.status+" "+thrownError);
                    }
                });
            }
            
            /*
             * invocato quando si cambia il valore della modifica rapida
             */
            function aggiornaValoreEtichetta(id) {
                var nomeElemento	 = document.getElementById("nomeElemento"+id).value;
                var etichettaElemento	 = document.getElementById("etichettaElemento"+id).value;
                
                if(etichettaElemento=="") {
                    document.getElementById("etichettaElemento"+id).value = nomeElemento;
                }
            }
            
        </script>
    </body>
</html>
